<?php
// Start session only if it's not already active
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}


include('sidebar.php');
include('header.php');
include('db_connection.php');

try {
    // Prepare and execute the query to fetch data from sign_up table
    $sql = "SELECT id, name, email, dob FROM sign_up";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $sign_upRecords = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="en">

<body>

    <!-- Table Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4">
                    <h6 class="mb-4">USER Table</h6>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Name</th>
                                    <th scope="col">Email</th>
                                    <th scope="col">DOB</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if ($sign_upRecords) {
                                    // Output data of each row
                                    foreach ($sign_upRecords as $sign_up) {
                                        echo "<tr>";
                                        echo "<th scope='row'>" . htmlspecialchars($sign_up['id']) . "</th>";
                                        echo "<td>" . htmlspecialchars($sign_up['name']) . "</td>";
                                        echo "<td>" . htmlspecialchars($sign_up['email']) . "</td>";
                                        echo "<td>" . htmlspecialchars($sign_up['dob']) . "</td>";
                                        echo "</tr>";
                                    }
                                } else {
                                    echo "<tr><td colspan='4'>No records found</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Table End -->

</body>

</html>