<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Product Page</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-4">

    <!-- Main Container -->
    <div class="flex flex-col lg:flex-row gap-4">
        
        <!-- Sidebar Filter Section -->
        <div class="lg:w-1/4 bg-white p-4 rounded shadow">
            <h2 class="font-semibold text-lg mb-4">Filter</h2>
            
            <!-- Color Filter -->
            <div class="mb-6">
                <h3 class="font-semibold text-sm mb-2">Pick Color</h3>
                <div class="flex space-x-2">
                    <span class="w-6 h-6 bg-red-500 rounded-full cursor-pointer" onclick="filterByColor('red')"></span>
                    <span class="w-6 h-6 bg-blue-500 rounded-full cursor-pointer" onclick="filterByColor('blue')"></span>
                    <span class="w-6 h-6 bg-green-500 rounded-full cursor-pointer" onclick="filterByColor('green')"></span>
                    <span class="w-6 h-6 bg-pink-500 rounded-full cursor-pointer" onclick="filterByColor('pink')"></span>
                </div>
            </div>
            
            <!-- Brand Filter -->
            <div class="mb-6">
                <h3 class="font-semibold text-sm mb-2">Brand</h3>
                <div class="space-y-1">
                    <label class="flex items-center">
                        <input type="checkbox" class="mr-2" onchange="filterByBrand()"> Reynomed
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" class="mr-2" onchange="filterByBrand()"> Blue World
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" class="mr-2" onchange="filterByBrand()"> Wearhouse
                    </label>
                    <label class="flex items-center">
                        <input type="checkbox" class="mr-2" onchange="filterByBrand()"> Umbroos
                    </label>
                </div>
            </div>
            
            <!-- Price Filter -->
            <div>
                <h3 class="font-semibold text-sm mb-2">Price</h3>
                <div class="space-y-1">
                    <label class="flex items-center">
                        <input type="radio" name="price" class="mr-2" onchange="filterByPrice(0, 100)"> 0 - 100
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="price" class="mr-2" onchange="filterByPrice(100, 150)"> 100 - 150
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="price" class="mr-2" onchange="filterByPrice(150, 200)"> 150 - 200
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="price" class="mr-2" onchange="filterByPrice(200, 250)"> 200 - 250
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="price" class="mr-2" onchange="filterByPrice(250, 300)"> 250 - 300
                    </label>
                </div>
            </div>
        </div>
        
        <!-- Product Section -->
        <div class="flex-1">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-2xl font-bold">Product List (56)</h2>
                <select class="border p-2 rounded" id="sort-by">
                    <option value="low-to-high">Low to High</option>
                    <option value="high-to-low">High to Low</option>
                </select>
            </div>
            
            <!-- Product Card -->
            <div id="product-list" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <div class="bg-white p-4 rounded shadow">
                    <div class="relative mb-4">
                        <img src="https://via.placeholder.com/150" alt="Product Image" class="w-full rounded">
                        <span class="absolute top-2 right-2 bg-red-500 text-white text-xs font-semibold px-2 py-1 rounded">25% OFF</span>
                    </div>
                    <h3 class="text-lg font-semibold">Gold Standard Whey Protein</h3>
                    <p class="text-gray-500 text-sm">(350)</p>
                    <p class="text-xl font-bold mt-2">₹2,365</p>
                    <button class="w-full bg-blue-500 text-white py-2 rounded mt-4">Add to cart</button>
                </div>
                <!-- More Product Cards -->
            </div>
        </div>
        
        <!-- Order Details Section -->
        <div class="lg:w-1/4 space-y-4">
            <!-- Track Order -->
            <div class="bg-white p-4 rounded shadow">
                <h2 class="font-semibold text-lg mb-4">Track Order</h2>
                <ul class="space-y-2">
                    <li class="flex items-center">
                        <span class="w-3 h-3 bg-green-500 rounded-full mr-2"></span> Pick-up Request Accepted
                    </li>
                    <li class="flex items-center">
                        <span class="w-3 h-3 bg-green-500 rounded-full mr-2"></span> Product Packed
                    </li>
                    <li class="flex items-center">
                        <span class="w-3 h-3 bg-green-500 rounded-full mr-2"></span> Dispatch has been done
                    </li>
                    <li class="flex items-center">
                        <span class="w-3 h-3 bg-blue-500 rounded-full mr-2"></span> Shipment Delivered
                    </li>
                </ul>
            </div>
            
            <!-- Price Details -->
            <div class="bg-white p-4 rounded shadow">
                <h2 class="font-semibold text-lg mb-4">Price Details</h2>
                <div class="text-sm space-y-1">
                    <div class="flex justify-between">
                        <span>Total No. of Items</span>
                        <span>1</span>
                    </div>
                    <div class="flex justify-between">
                        <span>Total MRP Value</span>
                        <span>₹2,365</span>
                    </div>
                    <div class="flex justify-between">
                        <span>Discount on MRP</span>
                        <span>₹500</span>
                    </div>
                    <div class="flex justify-between">
                        <span>Trainer Discount</span>
                        <span>₹100</span>
                    </div>
                    <div class="flex justify-between">
                        <span>Sub Total</span>
                        <span>₹1,765</span>
                    </div>
                    <div class="flex justify-between">
                        <span>GST</span>
                        <span>₹150</span>
                    </div>
                    <div class="flex justify-between font-bold text-lg mt-2">
                        <span>Total</span>
                        <span>₹1,915</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Sorting Logic
        document.getElementById("sort-by").addEventListener("change", function() {
            const sortBy = this.value;
            console.log(`Sorting by: ${sortBy}`);
            // Sorting logic can be implemented here
        });

        // Filter Functions
        function filterByColor(color) {
            console.log(`Filtering by color: ${color}`);
            // Filter logic for color
        }

        function filterByBrand() {
            console.log("Filtering by brand");
            // Filter logic for brand
        }

        function filterByPrice(min, max) {
            console.log(`Filtering by price: ${min} - ${max}`);
            // Filter logic for price
        }
    </script>

</body>
</html>
