<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BUILD-NET</title>
    <link rel="icon" sizes="180x180" href="images/logo-fav.ico">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
        html {
            scroll-behavior: smooth;
        }

        body {
            font-family: 'Inter', sans-serif;
            overflow-x: hidden;
        }
    </style>
</head>


<body class="bg-white">
    <header class="bg-black text-white flex items-center p-6">
        <!-- Logo -->
        <div class="ml-20 -mt-12">
            <!-- BUILD-NET -->
            <img src="images/logo.png" alt="Logo" class="w-40 h-auto">
        </div>
        <!-- Delivery location -->
        <div class="flex items-center text-sm mr-6">
            <i class="fas fa-map-marker-alt mr-2"></i>
            <span>Chinsurah,Hooghly,West Bengal</span>
        </div>

        <!-- Search bar -->
        <div class="flex-grow mx-6">
            <input type="text" placeholder="Search" class="w-full p-2 rounded-lg text-gray-700 placeholder-gray-500 focus:outline-none">
        </div>

        <!-- Navigation links -->
        <nav class="flex space-x-4 mr-6">

            <a href="#" class="text-white hover:border-b-2 hover:border-white pb-1">CATEGORIES</a>
            <a href="#" class="text-white hover:border-b-2 hover:border-white pb-1">BEST PRODUCTS</a>
        </nav>

        <!-- Icons -->
        <div class="flex items-center space-x-4">



            <!-- Cart icon with badge -->
            <div class="relative">
                <i class="fas fa-shopping-cart text-lg"></i>
                <span class="absolute -top-2 -right-3 bg-red-500 text-white text-xs rounded-full px-1"></span>
            </div>

            <!-- Profile picture -->
            <div class="w-8 h-8 rounded-full overflow-hidden border border-white">
                <img src="https://via.placeholder.com/32" alt="Profile" class="w-full h-full object-cover">
            </div>
        </div>
    </header>
    <div class="flex">




        <!-- Menu Toggle Button -->
        <button id="toggleSidebar" class="fixed top-4 left-4 z-50 p-2 text-white focus:outline-none">
            <div class="space-y-1">
                <span class="block w-6 h-0.5 bg-white transition-transform duration-300 ease-in-out"></span>
                <span class="block w-6 h-0.5 bg-white transition-transform duration-300 ease-in-out"></span>
                <span class="block w-6 h-0.5 bg-white transition-transform duration-300 ease-in-out"></span>
            </div>
        </button>

        <!-- Sidebar -->
        <aside id="sidebar" class="fixed top-0 left-0 h-full w-1/6 bg-gray-900 text-white transform -translate-x-full transition-transform duration-300 ease-in-out z-40">
            <div class="flex flex-col items-center py-8">
                <h1 class="text-2xl mb-8">BUILD-NET</h1>
                <hr class="border-gray-500 w-full mb-8">

                <nav class="space-y-6 text-lg font-semibold">
                    <a href="#dining" class="hover:underline">DINING</a><br>
                    <a href="#temple" class="hover:underline">TEMPLE</a><br>
                    <a href="#bedroom" class="hover:underline">BEDROOM</a><br>
                    <a href="#kitchen" class="hover:underline">KITCHEN</a><br>
                    <a href="#washroom" class="hover:underline">WASHROOM</a><br>
                </nav>

                <!-- Filter by BHK Type -->
                <div class="mt-8 w-full px-4">
                    <h2 class="text-lg font-semibold mb-4">Filter by BHK</h2>
                    <form id="bhk-filter" class="flex flex-col space-y-4">
                        <label class="text-sm flex items-center">
                            <input type="radio" name="bhk" value="1bhk" class="mr-2">
                            1BHK
                        </label>
                        <label class="text-sm flex items-center">
                            <input type="radio" name="bhk" value="2bhk" class="mr-2">
                            2BHK
                        </label>
                        <label class="text-sm flex items-center">
                            <input type="radio" name="bhk" value="3bhk" class="mr-2">
                            3BHK
                        </label>
                    </form>
                </div>

                <!-- Filter by Price -->
                <div class="mt-8 w-full px-4 border border-gray-500 rounded-lg p-6 bg-gray-800">
                    <h2 class="text-lg font-semibold text-gray-200 mb-6">Filter by Price</h2>
                    <form id="price-filter" class="space-y-5">
                        <div class="flex flex-col">
                            <label class="text-xs font-medium text-gray-400 mb-2">Min Price</label>
                            <input type="number" id="min-price" name="min-price" class="w-full px-3 py-2 border border-gray-600 rounded-lg bg-gray-700 text-gray-200 placeholder-gray-500 focus:outline-none focus:border-blue-500" placeholder="0">
                        </div>
                        <div class="flex flex-col">
                            <label class="text-xs font-medium text-gray-400 mb-2">Max Price</label>
                            <input type="number" id="max-price" name="max-price" class="w-full px-3 py-2 border border-gray-600 rounded-lg bg-gray-700 text-gray-200 placeholder-gray-500 focus:outline-none focus:border-blue-500" placeholder="1000">
                        </div>
                        <button type="submit" class="w-full py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg font-semibold transition duration-200 ease-in-out transform hover:scale-105">
                            Apply Filter
                        </button>
                    </form>
                </div>

            </div>
        </aside>




        <script>
            const sidebar = document.getElementById('sidebar');
            const toggleButton = document.getElementById('toggleSidebar');
            const menuLines = toggleButton.querySelectorAll('span');

            toggleButton.addEventListener('click', () => {
                // Toggle the sidebar's visibility
                if (sidebar.classList.contains('-translate-x-full')) {
                    sidebar.classList.remove('-translate-x-full');
                    sidebar.classList.add('translate-x-0');

                    // Transform the hamburger menu into an "X"
                    menuLines[0].classList.add('transform', 'rotate-45', 'translate-y-2');
                    menuLines[1].classList.add('opacity-0');
                    menuLines[2].classList.add('transform', '-rotate-45', '-translate-y-2');
                } else {
                    sidebar.classList.add('-translate-x-full');
                    sidebar.classList.remove('translate-x-0');

                    // Revert the "X" back to a hamburger menu
                    menuLines[0].classList.remove('transform', 'rotate-45', 'translate-y-2');
                    menuLines[1].classList.remove('opacity-0');
                    menuLines[2].classList.remove('transform', '-rotate-45', '-translate-y-2');
                }
            });
        </script>




        <div class="flex flex-col items-center">
            <!-- Dining Section -->
            <section id="dining" class="ml-1/6 w-full p-10 text-white">
                <h1 class="text-4xl mb-8 font-bold">DINING</h1>
                <div class="grid grid-cols-3 gap-6">
                    <!-- Image 1 -->
                    <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                        <img src="images/house.jpg" alt="Dining Image 1" class="w-full h-auto rounded-lg">
                        <p class="text-center mt-4 text-black font-semibold">Image 1</p>
                        <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                            Buy Now
                        </button>
                    </div>
                </div>



                <!-- Temple Section -->
                <section id="temple" class="ml-1/6 w-full p-10 text-white">
                    <h1 class="text-4xl mb-8 font-bold">TEMPLE</h1>
                    <div class="grid grid-cols-3 gap-6">
                        <div class="relative bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Temple Image 1" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 1</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                    </div>
                </section>

                <!-- Bedroom Section -->
                <section id="bedroom" class="ml-1/6 w-full p-10 text-white">
                    <h1 class="text-4xl mb-8 font-bold">BEDROOM</h1>
                    <div class="grid grid-cols-3 gap-6">
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Bedroom Image 1" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 1</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>


                    </div>
                </section>

                <!-- Kitchen Section -->
                <section id="kitchen" class="ml-1/6 w-full p-10 text-white">
                    <h1 class="text-4xl mb-8 font-bold">KITCHEN</h1>
                    <div class="grid grid-cols-3 gap-6">
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Kitchen Image 1" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 1</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Kitchen Image 2" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 2</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Kitchen Image 3" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 3</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Kitchen Image 4" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 4</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Kitchen Image 5" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 5</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Kitchen Image 6" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 6</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                    </div>
                </section>

                <!-- Washroom Section -->
                <section id="washroom" class="ml-1/6 w-full p-10 text-white">
                    <h1 class="text-4xl mb-8 font-bold">WASHROOM</h1>
                    <div class="grid grid-cols-3 gap-6">
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Washroom Image 1" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 1</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Washroom Image 2" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 2</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Washroom Image 3" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 3</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Washroom Image 4" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 4</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Washroom Image 5" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 5</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-lg transform transition-transform hover:scale-105">
                            <img src="images/house.jpg" alt="Washroom Image 6" class="w-full h-auto rounded-lg">
                            <p class="text-center mt-4 text-black font-semibold">Image 6</p>
                            <button class="absolute bottom-4 right-4 bg-blue-500 text-white py-1 px-3 rounded hover:bg-blue-600 transition-colors duration-300 text-sm font-semibold">
                                Buy Now
                            </button>
                        </div>
                    </div>
                </section>
        </div>

</body>



</html>