<?php
include('header.php');
include('sidebar.php');
include('db_connection.php');

// Handle form submissions for adding and deleting testimonials
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Add new testimonial
    if (isset($_POST['add'])) {
        $name = $_POST['name'];
        $date = $_POST['date'];
        $text = $_POST['text'];
        $rating = $_POST['rating']; // Get the rating


        // Check if the column already exists
        $checkColumnQuery = "SHOW COLUMNS FROM testimonial LIKE 'rating'";
        $stmt = $conn->prepare($checkColumnQuery);
        $stmt->execute();

        if ($stmt->rowCount() === 0) {
            // Add the column if it doesn't exist
            $addColumnQuery = "ALTER TABLE testimonial ADD COLUMN rating TINYINT(1) NOT NULL";
            $conn->exec($addColumnQuery);
        }

        // Validate the rating to ensure it's between 1 and 5
        if ($rating < 1 || $rating > 5) {
            echo "Rating must be between 1 and 5.";
        } else {
            // Insert into the testimonial table with the rating
            $query = "INSERT INTO testimonial (name, date, text, rating) VALUES (:name, :date, :text, :rating)";
            $stmt = $conn->prepare($query);
            $stmt->bindParam(':name', $name);
            $stmt->bindParam(':date', $date);
            $stmt->bindParam(':text', $text);
            $stmt->bindParam(':rating', $rating);
            $stmt->execute();
            echo "Testimonial added successfully!";
        }
    }

    // Delete testimonial
    if (isset($_POST['delete'])) {
        $id = $_POST['delete'];
        $stmt = $conn->prepare("DELETE FROM testimonial WHERE id = :id");
        $stmt->bindParam(':id', $id);
        $stmt->execute();
    }
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
</head>

<body>
    <!-- Form Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4">
                    <h6 class="mb-4">Manage Testimonials</h6>

                    <!-- Form for adding new testimonials -->
                    <form action="testimonial.php" method="POST">

                        <!-- Name -->
                        <div class="mb-3">
                            <label for="name" class="form-label">Name</label>
                            <input type="text" class="form-control" id="name" name="name" placeholder="Enter name" required>
                        </div>

                        <!-- Date -->
                        <div class="mb-3">
                            <label for="date" class="form-label">Date</label>
                            <input type="date" class="form-control" id="date" name="date" required>
                        </div>

                        <!-- Text -->
                        <div class="mb-3">
                            <label for="text" class="form-label">Testimonial Text</label>
                            <textarea class="form-control" id="text" name="text" placeholder="Enter testimonial" rows="3" required></textarea>
                        </div>

                        <!-- Rating -->
                        <div class="mb-3">
                            <label for="rating" class="form-label">Rating</label>
                            <select class="form-control" id="rating" name="rating" required>
                                <option value="1">1 - Poor</option>
                                <option value="2">2 - Fair</option>
                                <option value="3">3 - Good</option>
                                <option value="4">4 - Very Good</option>
                                <option value="5">5 - Excellent</option>
                            </select>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-primary" name="add">Add</button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Display existing testimonials -->
        <div class="row g-4 mt-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4">
                    <h6 class="mb-4">Existing Testimonials</h6>
                    <div class="row">
                        <?php
                        $stmt = $conn->query("SELECT * FROM testimonial");
                        while ($row = $stmt->fetch()) {
                            echo "<div class='col-md-4 mb-3'>";
                            echo "<div class='card h-100'>";
                            echo "<div class='card-body'>";
                            echo "<h5 class='card-title'>{$row['name']}</h5>";
                            echo "<p class='card-text'>{$row['text']}</p>";
                            echo "<p class='card-text'><small class='text-muted'>Date: {$row['date']}</small></p>";
                            echo "<p class='card-text'>Rating: {$row['rating']}</p>"; // Display the rating
                            echo "<form method='POST' style='display:inline;'>";
                            echo "<button type='submit' class='btn btn-danger' name='delete' value='{$row['id']}'>Delete</button>";
                            echo "</form>";
                            echo "</div></div></div>";
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>

</html>