<?php
// Start session only if it's not already active
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// // Check if user is logged in
// if (!isset($_SESSION['user_id'])) {
//     header("Location: signin.php"); // Redirect to sign-in page
//     exit(); // Stop further execution
// }

include('sidebar.php');
include('header.php');
include('db_connection.php'); // Include the database connection $conn

try {
    // Fetch teamlead data from the roll table
    $sql = "SELECT id, name, email, phone, created_at FROM roll WHERE role = 'teamlead'";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $teamleadRecords = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Teamlead Table</title>
</head>

<body>

    <!-- Table Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4">
                    <h6 class="mb-4">Teamlead Table</h6>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Name</th>
                                    <th scope="col">Email</th>
                                    <th scope="col">Phone</th>
                                    <th scope="col">Created At</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if ($teamleadRecords) {
                                    foreach ($teamleadRecords as $teamlead) {
                                        echo "<tr>";
                                        echo "<th scope='row'>" . htmlspecialchars($teamlead['id']) . "</th>";
                                        echo "<td>" . htmlspecialchars($teamlead['name']) . "</td>";
                                        echo "<td>" . htmlspecialchars($teamlead['email']) . "</td>";
                                        echo "<td>" . htmlspecialchars($teamlead['phone']) . "</td>";
                                        echo "<td>" . htmlspecialchars($teamlead['created_at']) . "</td>";
                                        echo "</tr>";
                                    }
                                } else {
                                    echo "<tr><td colspan='5'>No teamlead records found</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Table End -->

</body>

</html>