<?php

// Database connection setup
include('db_connection.php');

try {
    $conn = new PDO($dsn, $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// Process form submission 
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $dob = $_POST['dob'];
    $password = $_POST['password'];

    // Basic validation
    if (!empty($name) && !empty($email) && !empty($dob) && !empty($password)) {
        // Hash the password before storing it
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);

        // Insert into sign_up table
        $sql = "INSERT INTO sign_up (name, email, dob, password) VALUES (:name, :email, :dob, :password)";
        $stmt = $conn->prepare($sql);

        // Bind parameters
        $stmt->bindParam(':name', $name);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':dob', $dob);
        $stmt->bindParam(':password', $hashed_password);

        // Execute and check for success
        if ($stmt->execute()) {
            echo "<script>alert('Sign-up successful!');</script>";
            // Redirect to product.php
            header("Location: product.php");
            exit();
        } else {
            echo "<script>alert('Error: Could not complete sign-up.');</script>";
        }
    } else {
        echo "<script>alert('All fields are required!');</script>";
    }
}

$conn = null;
?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BUILD-NET</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>

<body class="bg-gray-100 min-h-screen flex items-center justify-center">
    <section class="bg-gradient-to-r from-blue-900 to-black text-white rounded-2xl shadow-lg overflow-hidden">
        <div class="flex flex-col lg:flex-row">
            <!-- Left Side: Image Section -->
            <div class="w-1/2">
                <div class="relative h-full p-4 pb-28 pr-0">
                    <img id="slideshowImage" class="object-cover h-full w-80 rounded-xl" src="images/bedroom.jpg" alt="Background Image">
                    <div class="absolute top-3 left-4">
                        <img src="images/logo.png" alt="BUILD-NET Logo" class="h-24 mb-4">
                    </div>
                    <div class="absolute bottom-0 left-0 p-6">
                        <h2 id="slideshowCaption" class="text-xl font-bold">Capturing Moments, Creating Memories</h2>
                    </div>
                </div>
            </div>

            <!-- Right Side: Form Section -->
            <div class="lg:w-1/2 pr-8 pl-6">
                <div class="flex-justify-center my-4 pl-3">
                    <h1 class="text-2xl text-white font-semibold">Sign up</h1>
                    <p class="text-gray-300 text-sm">Already have an account? <a href="sign-in.php" class="text-purple-400 hover:underline">Log in</a></p>
                </div>

                <div class="flex-col justify-center">
                    <form class="space-y-2" method="POST" action="" autocomplete="off" id="myForm">
                        <div class="px-4">
                            <label class="text-zinc-300 font-bold">Name <span class="text-red-600">*</span></label>
                            <input type="text" name="name" class="border rounded-lg bg-gray-700 border-gray-600 focus:outline-none focus:border-purple-500 w-full py-1 pl-2" placeholder="Henry Das" required autofocus>
                        </div>
                        <div class="px-4">
                            <label class="text-zinc-300 font-bold">Email <span class="text-red-600">*</span></label>
                            <input type="email" name="email" class="border rounded-lg bg-gray-700 border-gray-600 focus:outline-none focus:border-purple-500 w-full py-1 pl-2" placeholder="example@xyz.com" autocomplete="off" required>
                        </div>
                        <div class="px-4">
                            <label class="text-zinc-400 font-bold">Date of Birth <span class="text-red-600">*</span></label>
                            <input type="date" name="dob" class="border rounded-lg bg-gray-700 border-gray-600 focus:outline-none focus:border-purple-500 w-full py-1 pl-2" required>
                        </div>
                        <div class="px-4 relative">
                            <label class="text-zinc-400 font-bold">Enter your Password <span class="text-red-600">*</span></label>
                            <input type="password" name="password" id="password" class="border rounded-lg bg-gray-700 border-gray-600 focus:outline-none focus:border-purple-500 w-full py-1 pl-2" placeholder="****************" required>
                            <span id="togglePassword" class="absolute right-6 top-1/2 transform-translate-y-1/2 cursor-pointer text-gray-400 ">
                                <i class="fas fa-eye"></i>
                            </span>
                        </div>

                        <div class="flex justify-center py-4">
                            <button class="border-2 rounded-xl bg-orange-600 hover:bg-gradient-to-r from-purple-400 to-pink-800 text-white font-bold py-2 px-4 cursor-pointer" type="submit">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</body>

<script>
    // Toggle Password visibility
    const togglePassword = document.querySelector('#togglePassword');
    const password = document.querySelector('#password');

    togglePassword.addEventListener('click', function() {
        // Toggle the type attribute
        const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
        password.setAttribute('type', type);

        // Toggle the icon
        this.querySelector('i').classList.toggle('fa-eye');
        this.querySelector('i').classList.toggle('fa-eye-slash');
    });
</script>

</html>