<?php
// Start a session
session_start();

// Include the PDO database connection
include('db_connection.php');

// Initialize an error message variable
$error = "";

// Process form when submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $password = $_POST['password'];

    // Check if the email and password match the admin credentials
    if ($email === 'admin@gmail.com' && $password === '1234') {
        // Redirect to dashboard.php for admin
        header("Location: dashboard.php");
        exit();
    }

    // Otherwise, check in the `sign_up` table for a regular user
    $stmt = $conn->prepare("SELECT password FROM sign_up WHERE email = :email");
    $stmt->bindParam(':email', $email);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        // Verify the hashed password
        if (password_verify($password, $user['password'])) {
            // Redirect to product.php for regular users
            header("Location: product.php");
            exit();
        } else {
            $error = "Invalid email or password.";
        }
    } else {
        $error = "Invalid email or password.";
    }

    // Display the error message
    if ($error) {
        echo "<script>alert('$error');</script>";
    }
}
?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BUILD-NET</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&display=swap"> -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet"> -->
    <style>
        html,
        body {
            scroll-behavior: smooth;
            overflow: hidden;
            /* This disables the scroll bar */
        }

        body {
            font-family: 'Inter', sans-serif;
            overflow-x: hidden;
        }
    </style>
</head>


<body class="bg-gray-100 min-h-screen flex items-center justify-center">

    <section class=" bg-gradient-to-r from-blue-900 to-black text-white rounded-2xl shadow-lg overflow-hidden">
        <div class="flex flex-col lg:flex-row">
            <!-- Left Side: Image Section -->
            <div class="w-1/2">
                <div class="relative h-full p-4 pb-28 pr-0">
                    <img id="slideshowImage" class="object-cover h-full w-80 rounded-xl" src="images/bedroom.jpg"
                        alt="Background Image">
                    <div class="absolute top-3 left-4">
                        <img src="images/logo.png" alt="BUILD-NET Logo" class="h-24 mb-4">
                    </div>
                    <div class="absolute bottom-0 left-0 p-6">
                        <h2 id="slideshowCaption" class="text-xl font-bold">Capturing Moments, Creating Memories</h2>
                    </div>
                </div>
            </div>

            <!-- Right Side: Form Section -->
            <div class="lg:w-1/2 pr-8 py-4">
                <h2 class="text-2xl font-semibold pl-10">Welcome Back &#x2767;</h2>
                <p class=" text-gray-400 text-sm pl-10">Don't have an account? <a onclick="openSignUpPage()"
                        class="text-purple-400 hover:underline cursor-pointer">Sign up</a></p>

                <form method="post" action="sign-in.php" class="mt-8 space-y-3 space-x-2 pl-8">
                    <input type="email" name="email" placeholder="Email" required autocomplete="off" style="width: 265px;"
                        class="p-3 ml-2 rounded-lg bg-gray-700 border border-gray-600 focus:outline-none focus:border-purple-500">

                    <div class="relative">
                        <input type="password" name="password" id="passwordInput" placeholder="Enter your password" required
                            autocomplete="new-password"
                            class="w-full p-3 rounded-lg bg-gray-700 border border-gray-600 focus:outline-none focus:border-purple-500">
                        <i class="fa-solid fa-eye cursor-pointer absolute right-3 top-1/2 transform -translate-y-1/2"
                            id="togglePassword"></i>
                    </div>
                    <div class="flex items-center space-x-2 text-gray-400">
                        <input type="checkbox" id="terms" class="h-4 w-4 rounded-sm">
                        <label for="terms">I agree to the <a href="#" class="text-purple-400 hover:underline">Terms &
                                Conditions</a></label>
                    </div>

                    <button type="submit" id="createAccountButton"
                        class="w-full bg-orange-500 hover:bg-gradient-to-r from-purple-400 to-pink-800 text-white font-bold py-3 rounded-lg">
                        Log-in
                    </button>

                    <div class="mt-6 flex items-center">
                        <hr class="flex-grow border-gray-600">
                        <span class="px-3 text-gray-400">Or register with</span>
                        <hr class="flex-grow border-gray-600">
                    </div>

                    <div class="mt-5 flex space-x-4">
                        <button
                            class="flex items-center justify-center w-full bg-gray-700 text-white py-3 rounded-lg hover:bg-gray-600">
                            <img src="images/google-icon.png" alt="Google" class="w-5 h-5 mr-2"> Google
                        </button>
                        <button
                            class="flex items-center justify-center w-full bg-gray-700 text-white py-3 rounded-lg hover:bg-gray-600">
                            <img src="images/apple-icon.png" alt="Apple" class="w-5 h-5 mr-2">Facebook
                        </button>
                    </div>
            </div>
        </div>
    </section>

</body>

<script>
    // Redirect to the sign-up page
    function openSignUpPage() {

        window.location.href = "sign-up.php"; // sign-up page URL
    }

    // password eye button
    const togglePassword = document.querySelector('#togglePassword');
    const passwordInput = document.querySelector('#passwordInput');

    togglePassword.addEventListener('click', function() {
        const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordInput.setAttribute('type', type);
        this.classList.toggle('fa-eye-slash');
    });

    // create account button
    const termsCheckbox = document.getElementById('terms');
    const createAccountButton = document.getElementById('createAccountButton');

    // Disable the "Create account" button initially
    createAccountButton.disabled = true;

    // Enable/Disable the button based on the checkbox
    termsCheckbox.addEventListener('change', function() {
        if (this.checked) {
            createAccountButton.disabled = false;
        } else {
            createAccountButton.disabled = true;
        }
    });

    // Show the warning modal if the button is clicked without agreeing to terms
    createAccountButton.addEventListener('click', function(e) {
        if (!termsCheckbox.checked) {
            e.preventDefault(); // Prevent form submission or any default action
            warningModal.classList.remove('hidden');
        }
    });

    // Close the warning modal
    closeWarningButton.addEventListener('click', function() {
        warningModal.classList.add('hidden');
    });
</script>

</html>