<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Shipping Address</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-r from-blue-100 via-purple-100 to-pink-100 min-h-screen flex items-center justify-center p-6">

  <div class="bg-white shadow-lg rounded-xl p-8 max-w-3xl w-full">
    <h2 class="text-2xl font-bold text-gray-800 mb-6 text-center">Shipping Address</h2>

    <!-- Existing Addresses -->
    <div class="space-y-6">
      <!-- Address 1 -->
      <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between p-4 border border-gray-300 rounded-lg bg-gray-50 shadow-md">
        <label class="flex items-center space-x-3 w-full sm:w-auto">
          <input type="radio" name="address" class="form-radio h-5 w-5 text-blue-600">
          <span class="text-gray-800 font-medium">Courtney Henry</span>
        </label>
        <p class="text-gray-600 text-sm mt-2 sm:mt-0 flex-1 text-center sm:text-right sm:ml-6">3891 Ranchview, California 62639</p>
        <div class="mt-2 sm:mt-0 flex space-x-3 text-sm text-blue-500">
          <button class="hover:underline">Edit</button>
          <button class="hover:underline">Add Instructions</button>
        </div>
      </div>

      <!-- Address 2 -->
      <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between p-4 border border-gray-300 rounded-lg bg-gray-50 shadow-md">
        <label class="flex items-center space-x-3 w-full sm:w-auto">
          <input type="radio" name="address" class="form-radio h-5 w-5 text-blue-600">
          <span class="text-gray-800 font-medium">Jenny Wilson</span>
        </label>
        <p class="text-gray-600 text-sm mt-2 sm:mt-0 flex-1 text-center sm:text-right sm:ml-6">4140 Parker Rd. Allentown, New Mexico 31134</p>
        <div class="mt-2 sm:mt-0 flex space-x-3 text-sm text-blue-500">
          <button class="hover:underline">Edit</button>
          <button class="hover:underline">Add Instructions</button>
        </div>
      </div>
    </div>

    <!-- Add New Address Form -->
    <div class="mt-8">
      <div class="flex items-center space-x-3 mb-4">
        <input type="radio" name="address" class="form-radio h-5 w-5 text-blue-600" checked>
        <span class="text-gray-800 font-medium">Add New Address</span>
      </div>

      <form class="space-y-6">
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
          <div>
            <label class="block text-gray-700 text-sm font-medium">First Name</label>
            <input type="text" placeholder="Jaqob" class="mt-1 px-4 py-2 border border-gray-300 rounded-lg w-full focus:ring-blue-400 focus:border-blue-400">
          </div>
          <div>
            <label class="block text-gray-700 text-sm font-medium">Last Name</label>
            <input type="text" placeholder="Francize" class="mt-1 px-4 py-2 border border-gray-300 rounded-lg w-full focus:ring-blue-400 focus:border-blue-400">
          </div>
        </div>

        <div>
          <label class="block text-gray-700 text-sm font-medium">Street Address</label>
          <input type="text" placeholder="4140 Parker Rd. Allentown" class="mt-1 px-4 py-2 border border-gray-300 rounded-lg w-full focus:ring-blue-400 focus:border-blue-400">
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
          <div>
            <label class="block text-gray-700 text-sm font-medium">Apt Number</label>
            <input type="text" placeholder="556" class="mt-1 px-4 py-2 border border-gray-300 rounded-lg w-full focus:ring-blue-400 focus:border-blue-400">
          </div>
          <div>
            <label class="block text-gray-700 text-sm font-medium">State</label>
            <input type="text" placeholder="New Mexico" class="mt-1 px-4 py-2 border border-gray-300 rounded-lg w-full focus:ring-blue-400 focus:border-blue-400">
          </div>
          <div>
            <label class="block text-gray-700 text-sm font-medium">Zip Code</label>
            <input type="text" placeholder="31134" class="mt-1 px-4 py-2 border border-gray-300 rounded-lg w-full focus:ring-blue-400 focus:border-blue-400">
          </div>
        </div>

        <div class="flex justify-between space-x-4">
          <button type="button" class="px-6 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300">Cancel</button>
          <button type="submit" class="px-6 py-2 rounded-lg bg-orange-600 hover:bg-gradient-to-r from-purple-400 to-pink-800 text-white">Use This Address</button>
        </div>
      </form>
    </div>
  </div>

</body>
</html>
