<?php
// Start the session if it's not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Include the database connection file
include('db_connection.php');

try {
    // Check if the form is submitted via POST
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Get the submitted data
        $remarks = isset($_POST['remarks']) ? trim($_POST['remarks']) : null;
        $recordId = isset($_POST['record_id']) ? intval($_POST['record_id']) : null;

        // Validate the input
        if (empty($recordId) || empty($remarks)) {
            throw new Exception("Both record ID and remarks are required.");
        }

        // Prepare the SQL query to update the remarks column
        $sql = "UPDATE submit_connection SET remarks = :remarks WHERE id = :id";
        $stmt = $conn->prepare($sql);

        // Bind the parameters
        $stmt->bindParam(':remarks', $remarks, PDO::PARAM_STR);
        $stmt->bindParam(':id', $recordId, PDO::PARAM_INT);

        // Execute the query
        if ($stmt->execute()) {
            // Success message
            echo "<p style='color: green;'>Remarks updated successfully.</p>";
        } else {
            // Failure message
            throw new Exception("Failed to update remarks.");
        }
    } else {
        // Invalid request method
        throw new Exception("Invalid request method.");
    }
} catch (Exception $e) {
    // Display error message
    echo "<p style='color: red;'>Error updating remarks: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>
