<?php
// Start session only if it's not already active
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
// if (!isset($_SESSION['user_id'])) {
//     header("Location: signin.php");
//     exit();
// }

include('sidebar.php');
include('header.php');
include('db_connection.php'); // This includes the database connection $conn

try {
    // Handle form submission
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Collect form data
        $name = trim($_POST['name']);
        $email = trim($_POST['email']);
        $phone = trim($_POST['phone']);
        $password = trim($_POST['password']);

        // Basic validation
        if (empty($name) || empty($email) || empty($phone) || empty($password)) {
            die("All fields are required.");
        }

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            die("Invalid email format.");
        }

        // Hash password for security
        $hashed_password = password_hash($password, PASSWORD_BCRYPT);

        // Insert into the roll table as teamlead
        $role_type = "teamlead"; // Define role type as teamlead
        $stmt = $conn->prepare("INSERT INTO roll (name, email, phone, password, role) VALUES (:name, :email, :phone, :password, :role)");
        $stmt->bindParam(':name', $name);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':phone', $phone);
        $stmt->bindParam(':password', $hashed_password);
        $stmt->bindParam(':role', $role_type);

        // Execute the roll insert and check for errors
        if ($stmt->execute()) {
            echo "<script>alert('Teamlead Registration successful'); window.location.href = 'table_teamlead.php';</script>";
        } else {
            // Output error for roll insert
            echo "<script>alert('Error inserting into roll table: " . implode(", ", $stmt->errorInfo()) . "');</script>";
        }
    }
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">

<body>

    <!-- Form Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4 pr-5" style="padding-right: 2rem;">
                    <div class="container">
                        <h6 class="mb-4">Teamlead Registration</h6>
                        <form action="reg_teamlead.php" method="POST">

                            <!-- Teamlead Name -->
                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-control" id="name" name="name" required>
                            </div>

                            <!-- Email -->
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>

                            <!-- Phone -->
                            <div class="mb-3">
                                <label for="phone" class="form-label">Phone</label>
                                <input type="tel" class="form-control" id="phone" name="phone" required>
                            </div>

                            <!-- Password -->
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>

                            <!-- Submit Button -->
                            <button type="submit" class="btn btn-primary">Register</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Content End -->

</body>

</html>