<?php
// Assuming session and database connection are already set up
include('sidebar.php');
include('header.php');
include('db_connection.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);
    $teamlead_id = $_POST['teamlead_id']; // Teamlead selection

    // Validate fields
    if (empty($name) || empty($email) || empty($password) || empty($teamlead_id)) {
        die("All fields are required.");
    }

    // Check if the teamlead already has 5 masons
    $stmt = $conn->prepare("SELECT COUNT(*) FROM roll WHERE teamlead_id = :teamlead_id AND role = 'mason'");
    $stmt->bindParam(':teamlead_id', $teamlead_id);
    $stmt->execute();
    $mason_count = $stmt->fetchColumn();

    if ($mason_count >= 5) {
        die("This team lead already has the maximum number of masons.");
    }

    // Hash password and insert new mason record
    $hashed_password = password_hash($password, PASSWORD_BCRYPT);
    $stmt = $conn->prepare("INSERT INTO roll (name, email, password, role, teamlead_id) VALUES (:name, :email, :password, 'mason', :teamlead_id)");
    $stmt->bindParam(':name', $name);
    $stmt->bindParam(':email', $email);
    $stmt->bindParam(':password', $hashed_password);
    $stmt->bindParam(':teamlead_id', $teamlead_id);

    if ($stmt->execute()) {
        echo "<script>alert('Mason registered successfully'); window.location.href = 'table_mason.php';</script>";
    } else {
        echo "<script>alert('Error: " . implode(", ", $stmt->errorInfo()) . "');</script>";
    }
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">

</head>

<body>

    <!-- Form Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4 pr-5" style="padding-right: 2rem;">
                    <h6 class="mb-4">Mason Registration</h6>
                    <form action="reg_mason.php" method="POST">

                        <!-- Teamlead Selection Dropdown -->
                        <div class="mb-3">
                            <label for="teamlead">Select Team Lead</label>
                            <select id="teamlead" name="teamlead_id" class="form-control" required>
                                <?php
                                $teamleads = $conn->query("SELECT id, name FROM roll WHERE role = 'teamlead'")->fetchAll(PDO::FETCH_ASSOC);
                                foreach ($teamleads as $teamlead) {
                                    echo "<option value='" . htmlspecialchars($teamlead['id']) . "'>" . htmlspecialchars($teamlead['name']) . "</option>";
                                }
                                ?>
                            </select>
                        </div>

                        <!-- Name -->
                        <div class="mb-3">
                            <label for="name" class="form-label">Name</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>

                        <!-- Email -->
                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>

                        <!-- Password -->
                        <div class="mb-3">
                            <label for="password" class="form-label">Password</label>
                            <input type="password" class="form-control" id="password" name="password" required>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-primary">Register</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

</body>

</html>