<?php
include('header.php');
include('sidebar.php');
include('db_connection.php');

// Directory for uploads
$target_dir = "uploads/";

// Check if the directory exists, if not, create it
if (!is_dir($target_dir)) {
    mkdir($target_dir, 0777, true);  // Creates directory with full permissions
}

// Handle form submissions for adding and deleting products
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Add new product
    if (isset($_POST['add'])) {
        $title = $_POST['title'];
        $description = $_POST['description'];
        $price_min = $_POST['price_min'];
        $price_max = $_POST['price_max'];
        $image_path = null;

        // Handle file upload
        if (!empty($_FILES['image']['name'])) {
            $image_path = $target_dir . basename($_FILES['image']['name']);
            if (move_uploaded_file($_FILES['image']['tmp_name'], $image_path)) {
                $query = "INSERT INTO product_img (title, description, image_path, price_min, price_max) VALUES (:title, :description, :image_path, :price_min, :price_max)";
                $stmt = $conn->prepare($query);
                $stmt->bindParam(':title', $title);
                $stmt->bindParam(':description', $description);
                $stmt->bindParam(':image_path', $image_path);
                $stmt->bindParam(':price_min', $price_min);
                $stmt->bindParam(':price_max', $price_max);
                $stmt->execute();
            } else {
                echo "Failed to upload file.";
            }
        }
    }

    // Delete product
    if (isset($_POST['delete'])) {
        $id = $_POST['delete'];
        $stmt = $conn->prepare("DELETE FROM product_img WHERE id = :id");
        $stmt->bindParam(':id', $id);
        $stmt->execute();
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
</head>

<body>
    <!-- Form Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4">
                    <h6 class="mb-4">Add New Product</h6>

                    <!-- Form for adding new product -->
                    <form action="product_img.php" method="POST" enctype="multipart/form-data">

                        <!-- Title -->
                        <div class="mb-3">
                            <label for="title" class="form-label">Title</label>
                            <input type="text" class="form-control" id="title" name="title" placeholder="Enter product title" required>
                        </div>

                        <!-- Description -->
                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" id="description" name="description" placeholder="Enter a description" rows="3" required></textarea>
                        </div>

                        <!-- Minimum Price -->
                        <div class="mb-3">
                            <label for="price_min" class="form-label">Minimum Price</label>
                            <input type="number" class="form-control" id="price_min" name="price_min" placeholder="Enter minimum price" min="1000" max="1000000" required>
                        </div>

                        <!-- Maximum Price -->
                        <div class="mb-3">
                            <label for="price_max" class="form-label">Maximum Price</label>
                            <input type="number" class="form-control" id="price_max" name="price_max" placeholder="Enter maximum price" min="1000" max="1000000" required>
                        </div>

                        <!-- Image Upload -->
                        <div class="mb-3">
                            <label for="image" class="form-label">Image</label>
                            <input type="file" class="form-control" id="image" name="image" required>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-primary" name="add">Add Product</button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Display existing products -->
        <div class="row g-4 mt-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4">
                    <h6 class="mb-4">Existing Products</h6>
                    <div class="row">
                        <?php
                        $stmt = $conn->query("SELECT * FROM product_img");
                        while ($row = $stmt->fetch()) {
                            echo "<div class='col-md-4 mb-3'>";
                            echo "<div class='card h-100'>";
                            echo "<img src='{$row['image_path']}' class='card-img-top' alt='{$row['title']}'>";
                            echo "<div class='card-body'>";
                            echo "<h5 class='card-title'>{$row['title']}</h5>";
                            echo "<p class='card-text'>{$row['description']}</p>";
                            echo "<p class='card-text text-muted'>Price: ₹{$row['price_min']} - ₹{$row['price_max']}</p>";
                            echo "<form method='POST' style='display:inline;'>";
                            echo "<button type='submit' class='btn btn-danger' name='delete' value='{$row['id']}'>Delete</button>";
                            echo "</form>";
                            echo "</div></div></div>";
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>

</html>