<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Checkout Page</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen p-6">
  <div class="max-w-7xl mx-auto">
    <div class="text-center mb-12">
      <h1 class="text-4xl font-bold text-gray-800">Checkout</h1>
      <p class="text-gray-600 mt-2">Secure your items by completing your payment</p>
    </div>

    <div class="flex flex-col lg:flex-row gap-10">
      <!-- Payment Method Section -->
      <div class="bg-white p-8 rounded-lg shadow-lg w-full lg:w-2/3">
        <h2 class="text-2xl font-semibold text-gray-800 mb-6">Payment Method</h2>
        <div class="space-y-8">
          <!-- Credit or Debit Card Option -->
          <div class="border rounded-lg p-6">
            <label class="inline-flex items-center">
              <input type="radio" name="payment-method" class="form-radio text-green-500" checked>
              <span class="ml-2 text-lg font-medium text-gray-800">Credit or Debit Card</span>
            </label>
            <div class="space-y-4 mt-4">
              <input type="text" placeholder="Name on Card" class="w-full px-4 py-3 border rounded-lg focus:outline-none focus:ring focus:ring-green-200">
              <input type="text" placeholder="Card Number" class="w-full px-4 py-3 border rounded-lg focus:outline-none focus:ring focus:ring-green-200">
              <div class="flex gap-4">
                <input type="text" placeholder="Expire Date (MM/YY)" class="w-1/2 px-4 py-3 border rounded-lg focus:outline-none focus:ring focus:ring-green-200">
                <input type="text" placeholder="CVC/CVV" class="w-1/2 px-4 py-3 border rounded-lg focus:outline-none focus:ring focus:ring-green-200">
              </div>
              <div class="flex items-center">
                <input type="checkbox" class="form-checkbox text-green-500">
                <span class="ml-2 text-gray-700">Save this card</span>
              </div>
              <div class="flex gap-4 mt-4">
                <button class="w-full lg:w-1/2 px-4 py-3 border rounded-lg text-gray-700 hover:bg-gray-200">Cancel</button>
                <button class="w-full lg:w-1/2 px-4 py-3 bg-orange-600 hover:bg-gradient-to-r from-purple-400 to-pink-800 text-white">Use This Card</button>
              </div>
            </div>
          </div>

          <!-- Other Payment Options -->
          <div class="space-y-4">
            <div class="flex items-center border rounded-lg p-4 hover:bg-gray-50">
              <input type="radio" name="payment-method" class="form-radio text-green-500">
              <span class="ml-4 flex-grow text-gray-700 font-medium">PayPal</span>
              <img src="https://upload.wikimedia.org/wikipedia/commons/b/b5/PayPal.svg" alt="PayPal" class="w-6 h-6">
            </div>
            <div class="flex items-center border rounded-lg p-4 hover:bg-gray-50">
              <input type="radio" name="payment-method" class="form-radio text-green-500">
              <span class="ml-4 flex-grow text-gray-700 font-medium">Google Pay</span>
              <img src="https://upload.wikimedia.org/wikipedia/commons/5/5e/Google_Pay_logo.svg" alt="Google Pay" class="w-6 h-6">
            </div>
            <div class="flex items-center border rounded-lg p-4 hover:bg-gray-50">
              <input type="radio" name="payment-method" class="form-radio text-green-500">
              <span class="ml-4 flex-grow text-gray-700 font-medium">Apple Pay</span>
              <img src="https://upload.wikimedia.org/wikipedia/commons/f/fa/Apple_logo_black.svg" alt="Apple Pay" class="w-6 h-6">
            </div>
          </div>
        </div>
      </div>

      <!-- Order Summary Section -->
      <div class="bg-white p-8 rounded-lg shadow-lg w-full lg:w-1/3">
        <h2 class="text-2xl font-semibold text-gray-800 mb-6">Order Summary</h2>
        <div class="space-y-4">
          <!-- Order Items -->
          <div class="flex justify-between items-center">
            <span class="text-gray-700">Gaming Headphone</span>
            <span class="font-medium">€75.00</span>
          </div>
          <div class="flex justify-between items-center">
            <span class="text-gray-700">Super Laptop</span>
            <span class="font-medium">€98.86</span>
          </div>
          <div class="flex justify-between items-center">
            <span class="text-gray-700">Apple Watch 8</span>
            <span class="font-medium">€257.50</span>
          </div>
          <div class="flex justify-between items-center">
            <span class="text-gray-700">iPhone 12 Pro Max</span>
            <span class="font-medium">€291.07</span>
          </div>
          <div class="flex justify-between items-center">
            <span class="text-gray-700">Headphone Master</span>
            <span class="font-medium">€226.20</span>
          </div>
          <!-- Divider -->
          <hr class="my-4">
          <!-- Totals -->
          <div class="space-y-2">
            <div class="flex justify-between">
              <span class="text-gray-700">Items (5):</span>
              <span class="font-medium">€365.24</span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-700">Shipping & Handling:</span>
              <span class="font-medium">€2.50</span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-700">Before Tax:</span>
              <span class="font-medium">€387.74</span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-700">Tax Collected (20%):</span>
              <span class="font-medium">€73.54</span>
            </div>
            <hr class="my-4">
            <div class="flex justify-between text-lg font-semibold">
              <span>Order Total</span>
              <span>€504.77</span>
            </div>
            <button class="w-full mt-6 px-4 py-3 bg-orange-600 hover:bg-gradient-to-r from-purple-400 to-pink-800 text-white">
              Place Order
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
