<?php
// Start session only if it's not already active
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

include('sidebar.php');
include('header.php');
include('db_connection.php');

try {
    // Fetch data from the leads table
    $sql = "SELECT id, email, created_at FROM leads";
    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $leadsRecords = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="en">

<body>

    <!-- Table Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4">
                    <h6 class="mb-4">Leads Table</h6>
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Email</th>
                                    <th scope="col">Created At</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if ($leadsRecords) {
                                    // Output data of each row
                                    foreach ($leadsRecords as $lead) {
                                        echo "<tr>";
                                        echo "<th scope='row'>" . htmlspecialchars($lead['id']) . "</th>";
                                        echo "<td>" . htmlspecialchars($lead['email']) . "</td>";
                                        echo "<td>" . htmlspecialchars($lead['created_at']) . "</td>";
                                        echo "</tr>";
                                    }
                                } else {
                                    echo "<tr><td colspan='3'>No records found</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Table End -->

</body>

</html>
