<?php
// Connect to the database
include 'db_connection.php';

try {
  // Fetch the latest banner content from the database
  $query = "SELECT * FROM banner_content ORDER BY id DESC LIMIT 1";
  $stmt = $conn->query($query);
  $banner = $stmt->fetch(PDO::FETCH_ASSOC);
  $images = json_decode($banner['images'], true); // Decode JSON images array
} catch (PDOException $e) {
  echo "Error fetching banner content: " . $e->getMessage();
}

try {
  // Fetch testimonials from the 'testimonial' table
  $stmt = $conn->query("SELECT text, name, date, rating FROM testimonial");
  $testimonials = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
  echo "Error: " . $e->getMessage();
}

try {
  $conn->exec("ALTER TABLE testimonial ADD COLUMN rating INT(1) NOT NULL DEFAULT 5");
  echo "Column 'rating' added successfully.";
} catch (PDOException $e) {
  echo "Error adding column 'rating': " . $e->getMessage();
}

// Fetch the design steps from the database
$query = "SELECT * FROM design ORDER BY id ASC";
$stmt = $conn->query($query);
$design_steps = $stmt->fetchAll(PDO::FETCH_ASSOC);



// Fetch active FAQs
$stmt = $conn->query("SELECT * FROM faq WHERE status = 'active'");
$faqs = $stmt->fetchAll();
// Handling form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);

  if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
      try {
          $stmt = $conn->prepare("INSERT INTO leads (email) VALUES (:email)");
          $stmt->bindParam(':email', $email);
          $stmt->execute();
          echo "Thank you! Your email has been added.";
      } catch (PDOException $e) {
          if ($e->getCode() == 23000) { // Duplicate entry error
              echo "This email is already subscribed.";
          } else {
              echo "Error: " . $e->getMessage();
          }
      }
  } else {
      echo "Invalid email address.";
  }
}



?>


<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>BUILD-NET</title>
  <link rel="icon" sizes="180x180" href="images/logo-fav.ico">
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&display=swap">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
  <style>
    html {
      scroll-behavior: smooth;
    }

    body {
      font-family: 'Inter', sans-serif;
      overflow-x: hidden;
    }
  </style>
</head>


<body class="bg-gradient-to-r from-blue-900 to-black">
<nav class="bg-gradient-to-r from-blue-900 to-black text-white py-4">
  <div class="container mx-auto px-4 flex items-center justify-between flex-wrap">
    <!-- Logo -->
    <div class="flex items-center flex-shrink-0">
      <img src="images/logo.png" alt="Logo" class="w-40 h-auto">
    </div>

    <!-- Hamburger Menu for Mobile -->
    <div class="block lg:hidden">
      <button 
        class="text-white hover:text-gray-400 focus:outline-none" 
        id="menu-toggle">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16m-7 6h7"></path>
        </svg>
      </button>
    </div>

    <!-- Navigation Links -->
    <div 
      class="w-full lg:flex lg:items-center lg:w-auto hidden" 
      id="menu-content">
      <div class="text-sm lg:flex-grow space-y-4 lg:space-y-0 lg:space-x-10 mt-4 lg:mt-0 text-center lg:text-left">
        <a href="#" class="hover:text-gray-400 hover:underline cursor-pointer block lg:inline">Home</a>
        <a href="#product" class="hover:text-gray-400 hover:underline cursor-pointer block lg:inline">Products</a>
        <a href="#step" class="hover:text-gray-400 hover:underline cursor-pointer block lg:inline">Step</a>
        <a href="#faq" class="hover:text-gray-400 hover:underline cursor-pointer block lg:inline">FAQ</a>
        <a href="#about" class="hover:text-gray-400 hover:underline cursor-pointer block lg:inline pr-8">About us</a>
      </div>

      <div class="mt-4 lg:mt-0 space-y-4 lg:space-y-0 lg:space-x-4 text-center lg:text-left">
        <a onclick="openSignInPage()" 
          class="hover:text-gray-400 cursor-pointer block lg:inline">Sign in</a>
        <a onclick="openSignUpPage()" 
          class="bg-orange-600 hover:bg-gradient-to-r from-purple-400 to-pink-800 text-white font-bold py-2 px-4 rounded cursor-pointer block lg:inline">
          Sign up
        </a>
      </div>
    </div>
  </div>
</nav>

<script>
  // Toggle menu visibility on smaller screens
  const menuToggle = document.getElementById("menu-toggle");
  const menuContent = document.getElementById("menu-content");

  menuToggle.addEventListener("click", () => {
    menuContent.classList.toggle("hidden");
  });
</script>

<div class="flex flex-col lg:flex-row items-center justify-between mt-4 px-4 sm:px-6 lg:px-8">
  <!-- Left Section -->
  <div class="flex flex-col text-center lg:text-left mt-8 lg:mt-0 mb-8 lg:mb-0 lg:w-1/2 px-4 lg:px-8">
    <!-- Headline -->
    <h2 class="text-2xl sm:text-3xl lg:text-5xl font-semibold mb-6 bg-gradient-to-r from-purple-400 to-pink-600 text-transparent bg-clip-text">
      <?= htmlspecialchars($banner['headline']) ?>
    </h2>
    <!-- Description -->
    <p class="text-gray-400 mb-8 max-w-xl mx-auto lg:mx-0">
      <?= htmlspecialchars($banner['description']) ?>
    </p>
    <!-- Email Input and Button -->
    <div class="flex flex-col sm:flex-row justify-center lg:justify-start items-center mb-8 w-full max-w-md mx-auto lg:mx-0">
    <form method="POST" action="index.php" class="flex flex-col sm:flex-row">
  <input 
    type="email" 
    name="email" 
    placeholder="Your Email Address" 
    required 
    class="p-3 rounded-t-md sm:rounded-l-md sm:rounded-tr-none text-gray-100 w-full sm:w-3/4 bg-gray-800 mb-2 sm:mb-0"
  >
  <button 
    type="submit" 
    class="bg-orange-600 hover:bg-gradient-to-r from-purple-400 to-pink-800 text-white px-6 rounded-b-md sm:rounded-r-md sm:rounded-bl-none w-full sm:w-1/4 py-2 lg:py-0"
  >
    Get Started
  </button>
</form>


    </div>
    <!-- Images and Access Text -->
    <div class="flex items-center justify-center lg:justify-start space-x-4">
      <!-- Profile Images -->
      <div class="flex -space-x-3">
        <?php
        $images = json_decode($banner['images'], true);
        if (json_last_error() === JSON_ERROR_NONE && is_array($images)):
          foreach ($images as $img): ?>
            <img 
              src="<?= htmlspecialchars($img) ?>" 
              class="w-10 h-10 rounded-full border-2 border-white" 
              alt="Profile Image"
            >
          <?php endforeach;
        else: ?>
          <p>No images available.</p>
        <?php endif; ?>
      </div>
      <!-- Access Text -->
      <span class="text-gray-400 text-sm"><?= htmlspecialchars($banner['access_text']) ?></span>
    </div>
  </div>

  <!-- Right Section -->
  <div class="w-full lg:w-1/2 flex justify-center lg:justify-end px-4 lg:px-8">
    <img 
      src="<?= htmlspecialchars($banner['main_image']) ?>" 
      alt="House Image" 
      class="w-full max-w-xs sm:max-w-sm lg:max-w-lg h-auto rounded-lg shadow-xl"
    >
  </div>
</div>


  <!-- choose us section -->
  <section class="bg-gray-200 flex items-center justify-center">
    <div class="mx-16 overflow-hidden">
      <h2 class="text-center text-3xl font-semibold mb-8 mt-20">Why Choose Us</h2>
      <div class="flex transition-transform ease-linear duration-[10ms] mb-20 space-x-8" id="scroll-container">
        <?php
        // Fetching data from choose_us table using PDO
        $stmt = $conn->query("SELECT * FROM choose_us");
        while ($row = $stmt->fetch()) {
          echo "<div class='p-4'>";
          echo "<div class='flex flex-col items-center'>";
          echo "<img src='{$row['image_path']}' alt='{$row['title']}' class='w-28 h-16'>";
          echo "<p class='mt-2 text-center'>{$row['description']}</p>";
          echo "</div></div>";
        }
        ?>
      </div>
    </div>
  </section>


  <div class="bg-black text-white py-8 px-4 sm:px-6 lg:px-8" id="product">
  <!-- Title and Subtitle -->
  <div class="text-center lg:text-left mb-6 lg:mb-8">
    <h1 class="text-3xl lg:text-5xl font-bold pb-2 bg-gradient-to-r from-purple-400 to-pink-600 text-transparent bg-clip-text">
      A lot is happening,
    </h1>
    <h2 class="text-2xl lg:text-4xl font-bold pb-6 bg-gradient-to-r from-purple-400 to-pink-600 text-transparent bg-clip-text">
      We are blogging about it.
    </h2>
  </div>

  <!-- Blog Posts Grid -->
  <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mx-auto max-w-7xl">
    <!-- Large Blog Post -->
    <div class="relative col-span-1 md:col-span-2 row-span-2">
      <img src="images/dinning room.jpg" alt="Blog Image" class="w-full h-full object-cover rounded-lg">
      <div class="absolute inset-0 hover:bg-gradient-to-t hover:from-[#eda997] to-transparent p-4 flex flex-col justify-end">
        <h2 class="text-lg font-semibold mb-2">DINNING HALL</h2>
        <a href="#" class="text-sm text-[#BF4CDA] underline">See more images</a>
      </div>
    </div>

    <!-- Smaller Blog Posts -->
    <div class="relative">
      <img src="images/Temple.png" alt="Blog Image" class="w-full h-60 object-cover rounded-lg">
      <div class="absolute inset-0 p-4 flex flex-col justify-end">
        <h2 class="text-lg font-semibold mb-2">TEMPLE</h2>
        <a href="#" class="text-sm text-[#BF4CDA] underline">See more images</a>
      </div>
    </div>

    <div class="relative">
      <img src="images/bedroom.jpg" alt="Blog Image" class="w-full h-60 object-cover rounded-lg">
      <div class="absolute inset-0 p-4 flex flex-col justify-end">
        <h2 class="text-lg font-semibold mb-2">BEDROOM</h2>
        <a href="#" class="text-sm text-[#BF4CDA] underline">See more images</a>
      </div>
    </div>

    <div class="relative">
      <img src="images/kitchen.jpeg" alt="Blog Image" class="w-full h-60 object-cover rounded-lg">
      <div class="absolute inset-0 p-4 flex flex-col justify-end">
        <h2 class="text-lg font-semibold mb-2">KITCHEN</h2>
        <a href="#" class="text-sm text-[#BF4CDA] underline">See more images</a>
      </div>
    </div>

    <div class="relative">
      <img src="images/bathroom.jpeg" alt="Blog Image" class="w-full h-60 object-cover rounded-lg">
      <div class="absolute inset-0 p-4 flex flex-col justify-end">
        <h2 class="text-lg font-semibold mb-2">WASHROOM</h2>
        <a href="#" class="text-sm text-[#BF4CDA] underline">See more images</a>
      </div>
    </div>
  </div>
</div>


  <!-- Design Session Section -->
  <section class="bg-gray-200 container mx-auto py-8">
    <h2 class="text-2xl font-semibold text-center mb-8">What is a Design Session?</h2>

    <div class="flex flex-col md:flex-row justify-around items-center px-12 ">

      <?php
      // Loop through each design step and display it
      foreach ($design_steps as $step):
      ?>

        <!-- Step -->
        <div class="flex flex-col items-center text-center px-2">
          <img src="<?= $step['image_path']; ?>" alt="<?= $step['step_title']; ?>" class="w-auto h-32 mb-4">
          <p class="text-sm font-normal"><?= $step['step_title']; ?></p>
          <p class="text-xs font-normal"><?= $step['step_description']; ?></p>
        </div>

      <?php endforeach; ?>

    </div>
  </section>

  <!-- session book -->
  <section class="flex items-center justify-center py-20 bg-gray-200" id="step">
    <div class="flex bg-white rounded-lg shadow-lg px-4 py-8">
      <div class="w-1/2 pr-6">
        <img src="images/free_design.jpg" alt="Living Room" class="rounded-md w-full h-60" />
      </div>
      <div class="w-1/2 flex flex-col justify-center">
        <h2 class="text-xl font-bold mb-4">Complete home interiors in 3 easy steps</h2>
        <div class="flex items-center mb-4">
          <span id="step1"
            class="bg-gradient-to-r from-purple-400 to-pink-600 text-transparent bg-clip-text font-extrabold text-xl">1</span>
          <div class="flex-grow h-1 bg-gray-300 mx-2"></div>
          <span id="step2"
            class="bg-gradient-to-r from-purple-400 to-pink-600 text-transparent bg-clip-text font-extrabold text-xl">2</span>
          <div class="flex-grow h-1 bg-gray-300 mx-2 "></div>
          <span id="step3"
            class="bg-gradient-to-r from-purple-400 to-pink-600 text-transparent bg-clip-text font-extrabold text-xl">3</span>
        </div>
        <h3 id="heading"
          class="bg-gradient-to-r from-purple-400 to-pink-600 text-transparent bg-clip-text font-extrabold mb-2">Discover
        </h3>
        <p id="description" class="text-gray-700 mb-6">Explore more than just modular design ideas with our experts.</p>
        <button
          class="text-white hover:bg-red-500 transition duration-200 bg-orange-600 hover:bg-gradient-to-r from-purple-400 to-pink-800 font-bold py-2 px-4 rounded cursor-pointer">

          BOOK FREE DESIGN SESSION
        </button>
      </div>
    </div>
  </section>

  <!-- testimonial -->
  <section class="bg-gradient-to-r from-blue-900 to-black flex items-center justify-center h-auto lg:h-2/4 px-4"
    id="testimonials">
    <div class="relative w-full max-w-4xl text-white rounded-xl p-4 lg:p-20">
      <div class="flex flex-col lg:flex-row justify-between items-center mb-4">
        <button id="prevBtn" class="text-2xl text-white hover:text-gray-400 mb-4 lg:mb-0">
          <span>&larr;</span>
        </button>
        <div class="text-center flex-1">
          <h2 class="text-lg font-bold" id="testimonial-name"></h2>
          <p class="text-sm text-gray-500 font-bold" id="testimonial-date"></p>
        </div>
        <button id="nextBtn" class="text-2xl text-white hover:text-gray-400 mt-4 lg:mt-0">
          <span>&rarr;</span>
        </button>
      </div>
      <p class="text-center mb-2 text-base font-medium" id="testimonial-text">
      </p>
      <div class="text-center">
        <div class="inline-flex">
        </div>
      </div>
    </div>
  </section>


  <!-- FAQ Section -->
  <section class="bg-gray-200 pb-12" id="faq">
    <div class="container mx-auto p-4 sm:p-8">
      <h2 class="text-2xl sm:text-3xl md:text-4xl font-black text-center mb-4 mt-8">Frequently asked questions</h2>
      <p class="text-center font-semibold text-gray-500 mb-8">Your FAQs answered here.</p>

      <div class="grid grid-cols-1 md:grid-cols-2 gap-6 px-4 sm:px-8">
        <?php foreach ($faqs as $faq) : ?>
          <div class="faq-item bg-white p-4 rounded shadow-md">
            <button class="faq-question text-lg font-semibold flex justify-between w-full">
              <?= htmlspecialchars($faq['question']) ?>
            </button>
            <div class="faq-answer mt-2">
              <p class="text-gray-700"><?= htmlspecialchars($faq['answer']) ?></p>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
      <p class="text-gray-800 text-md text-center mt-12">
        Can't find an answer? <a href="mailto:support@build-net.com" class="text-blue-500">Email us</a>
      </p>

    </div>
  </section>
  <div class="bg-gradient-to-r from-blue-900 to-black text-white py-16" id="about">
  <!-- Heading Section -->
  <div class="text-center">
    <h1 class="text-4xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-purple-500 to-orange-500 mb-8">
      Do you want your dream house with BUILD-NET
    </h1>
    <button
      class="px-8 py-3 bg-orange-600 border border-white text-white hover:bg-gradient-to-r from-purple-400 to-pink-800 transition duration-300">
      Request Early Access
    </button>
  </div>

  <!-- Footer Section -->
  <div class="mt-16">
    <div class="flex flex-col sm:flex-row justify-between items-center text-sm mx-auto w-11/12 sm:w-3/4 border-t border-gray-600 pt-8">
      <!-- GPT-3 Brand Section -->
      <div class="mb-8 sm:mb-0">
        <div class="-pt-24">
          <img src="images/logo.png" alt="Logo" class="w-40 h-auto"> <!-- Adjust the size as needed -->
        </div>
      </div>

      <!-- Company Section -->
      <div class="get-in-touch pr-8 ml-8 md:pt-3 sm:mt-0 mt-8">
        <h4 class="font-bold text-white text-xl pb-4">Company</h4>
        <ul>
          <li class="pb-4 hover:text-gray-400 cursor-pointer" id="terms-conditions-trigger">Terms & Conditions</li>
          <li class="pb-4 hover:text-gray-400 cursor-pointer" id="privacy-policy-trigger">Privacy Policy</li>
        </ul>
      </div>

      <!-- Privacy Policy Modal -->
      <div id="privacy-policy-modal"
        class="fixed inset-0 bg-gray-900 bg-opacity-50 flex justify-center items-center hidden">
        <div class="bg-white rounded-lg shadow-lg p-5 pb-6 md:w-1/2 w-full mx-2">
          <div class="flex justify-between items-center mb-4">
            <h4 class="text-2xl font-bold">Privacy Policy</h4>
            <button id="close-privacy-modal"
              class="text-gray-700 hover:text-gray-900 focus:outline-none">&times;</button>
          </div>
          <div class="overflow-y-auto max-h-80">
            <p class="text-gray-900">
              <b class="text-xl font-bold">Privacy Policy</b><br>
              We value your privacy and are committed to protecting your personal information...
            </p>
          </div>
        </div>
      </div>

      <!-- Terms & Conditions Modal -->
      <div id="terms-conditions-modal"
        class="fixed inset-0 bg-gray-900 bg-opacity-50 flex justify-center items-center hidden">
        <div class="bg-white rounded-lg shadow-lg p-5 pb-6 md:w-1/2 w-full mx-2">
          <div class="flex justify-between items-center mb-4">
            <h4 class="text-2xl font-bold">Terms & Conditions</h4>
            <button id="close-terms-modal" class="text-gray-700 hover:text-gray-900 focus:outline-none">&times;</button>
          </div>
          <div class="overflow-y-auto max-h-80">
            <p class="text-gray-900">
              <b class="text-xl font-bold">Terms & Conditions</b><br>
              This section outlines the terms and conditions for using our website...
            </p>
          </div>
        </div>
      </div>

      <!-- Get in Touch Section -->
      <div class="get-in-touch pr-8 ml-8 md:pt-2">
        <h4 class="font-bold text-white text-xl">Get In Touch</h4>
        <p class="mb-2 mt-2"><i class="fas fa-envelope mr-2"></i>support@build-net.com</p>
        <p class="mb-2"><i class="fas fa-phone-alt mr-2"></i> +91 70070 39955</p>
        <p><i class="fas fa-map-marker-alt mr-2"></i>Kolkata, West Bengal</p>
      </div>
    </div>

    <!-- Copyright Section -->
    <div class="flex flex-col sm:flex-row text-center text-gray-400 pt-12 mx-4 sm:mx-52 text-sm">
      <div class="flex justify-center sm:justify-start mb-4 sm:mb-0">
        <a href="https://www.facebook.com" class="text-white hover:text-black pr-4"><i class="fab fa-facebook-f"></i></a>
        <a href="https://www.linkedin.com" class="text-white hover:text-black pr-4"><i class="fab fa-linkedin-in"></i></a>
        <a href="https://www.youtube.com" class="text-white hover:text-black pr-4"><i class="fab fa-youtube"></i></a>
      </div>
      <p class="sm:pl-72 pl-0">&copy; 2021 BUILD-NET All rights reserved.</p>
    </div>
  </div>
</div>

<script>
  // Terms & Conditions Modal
  document.getElementById('terms-conditions-trigger').addEventListener('click', function() {
    document.getElementById('terms-conditions-modal').classList.remove('hidden');
    document.body.classList.add('overflow-hidden');
  });

  document.getElementById('close-terms-modal').addEventListener('click', function() {
    document.getElementById('terms-conditions-modal').classList.add('hidden');
    document.body.classList.remove('overflow-hidden');
  });

  // Privacy Policy Modal
  document.getElementById('privacy-policy-trigger').addEventListener('click', function() {
    document.getElementById('privacy-policy-modal').classList.remove('hidden');
    document.body.classList.add('overflow-hidden');
  });

  document.getElementById('close-privacy-modal').addEventListener('click', function() {
    document.getElementById('privacy-policy-modal').classList.add('hidden');
    document.body.classList.remove('overflow-hidden');
  });
</script>



    <script>
      // Redirect to the sign-up page
      function openSignUpPage() {

        window.location.href = "sign-up.php"; // sign-up page URL
      }


      // Redirect to the sign-in page
      function openSignInPage() {

        window.location.href = "sign-in.php"; // sign-in page URL
      }


      //For choose-us section
      const scrollContainer = document.getElementById('scroll-container');
      const scrollStep = 1; // Speed of the scroll

      let scrollAmount = 0;

      function autoScroll() {
        scrollAmount -= scrollStep;
        // Reset the scroll amount once half of the total width is scrolled to create a loop
        if (Math.abs(scrollAmount) >= scrollContainer.scrollWidth / 2) {
          scrollAmount = 0;
        }
        scrollContainer.style.transform = `translateX(${scrollAmount}px)`;
      }

      setInterval(autoScroll, 20); // Adjust the interval to control speed

      // For free-design section
      const steps = [{
          step: 1,
          heading: 'Discover',
          text: 'Explore more than just modular design ideas with our experts.'
        },
        {
          step: 2,
          heading: 'Plan',
          text: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.'
        },
        {
          step: 3,
          heading: 'Create',
          text: 'Epsom salt is used in baths for relaxation and pain relief.'
        }
      ];

      let currentStep = 0;

      function updateStep() {
        // Update the step numbers and styles
        document.getElementById('step1').classList.toggle('text-red-600', currentStep === 0);
        document.getElementById('step1').classList.toggle('text-gray-500', currentStep !== 0);

        document.getElementById('step2').classList.toggle('text-red-600', currentStep === 1);
        document.getElementById('step2').classList.toggle('text-gray-500', currentStep !== 1);

        document.getElementById('step3').classList.toggle('text-red-600', currentStep === 2);
        document.getElementById('step3').classList.toggle('text-gray-500', currentStep !== 2);

        // Update the heading and text
        document.getElementById('heading').textContent = steps[currentStep].heading;
        document.getElementById('description').textContent = steps[currentStep].text;

        // Move to the next step
        currentStep = (currentStep + 1) % steps.length;
      }

      // Update every 1 seconds
      setInterval(updateStep, 1000);

      // Initialize with the first step
      updateStep();

      //For testimonial section 

      // Convert PHP testimonials to JavaScript array
      const testimonials = <?php echo json_encode($testimonials); ?>;

      const nextBtn = document.getElementById('nextBtn');
      const prevBtn = document.getElementById('prevBtn');
      const testimonialText = document.getElementById('testimonial-text');
      const testimonialName = document.getElementById('testimonial-name');
      const testimonialDate = document.getElementById('testimonial-date');
      const starsContainer = document.querySelector('.inline-flex');
      let currentIndex = 0;

      function updateTestimonial(index) {
        const testimonial = testimonials[index];
        testimonialText.textContent = testimonial.text;
        testimonialName.textContent = testimonial.name;
        testimonialDate.textContent = testimonial.date;

        starsContainer.innerHTML = '';
        for (let i = 0; i < 5; i++) {
          starsContainer.innerHTML += i < testimonial.rating ?
            '<span class="text-yellow-500">&#9733;</span>' :
            '<span class="text-gray-400">&#9733;</span>';
        }
      }

      nextBtn.addEventListener('click', () => {
        currentIndex = (currentIndex + 1) % testimonials.length;
        updateTestimonial(currentIndex);
      });

      prevBtn.addEventListener('click', () => {
        currentIndex = (currentIndex - 1 + testimonials.length) % testimonials.length;
        updateTestimonial(currentIndex);
      });

      updateTestimonial(currentIndex);
    </script>

</html>