
<?php
include 'db_connection.php';

try {
    // Query to get the latest name from the sign_up table
    $sign_up_query = "SELECT name FROM sign_up ORDER BY id DESC LIMIT 1";
    $sign_up_stmt = $conn->prepare($sign_up_query);
    $sign_up_stmt->execute();
    $sign_up_name = $sign_up_stmt->fetchColumn(); // Fetch single value
    $sign_up_name = $sign_up_name ?: 'N/A'; // Default value if null

    // Query to get the latest name from the roll table
    $roll_query = "SELECT name FROM roll ORDER BY id DESC LIMIT 1";
    $roll_stmt = $conn->prepare($roll_query);
    $roll_stmt->execute();
    $roll_name = $roll_stmt->fetchColumn(); // Fetch single value
    $roll_name = $roll_name ?: 'N/A'; // Default value if null
} catch (PDOException $e) {
    // Handle errors (e.g., log them for debugging)
    die("Error fetching data: " . $e->getMessage());
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ECOMMERCE-MLM</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gray-100">

    <!-- Navbar Start -->
    <nav class="bg-white shadow sticky top-0 z-10">
        <div class="container mx-auto px-4 flex justify-between items-center py-2">
            <!-- Sidebar Toggle -->
            <a href="#" class="text-gray-700">
                <i class="fas fa-bars"></i>
            </a>

            <!-- Search Bar -->
            <form class="hidden md:flex items-center">
                <input class="border rounded-full px-4 py-2 focus:outline-none focus:ring focus:ring-blue-500" type="search" placeholder="Search">
            </form>

            <!-- Right Section -->
            <div class="flex items-center space-x-4">
                <!-- Messages Dropdown -->
                <div class="relative">
                    <!-- Dropdown Toggle -->
                    <a href="javascript:void(0);"
                        class="text-gray-700 hover:text-blue-500 flex items-center"
                        id="messagesDropdownToggle"
                        onclick="toggleMessagesDropdown(event)">
                        <i class="fas fa-envelope"></i>
                        <span class="hidden lg:inline pr-2">Messages</span>
                        <!-- Dropdown Icon -->
                        <svg xmlns="http://www.w3.org/2000/svg"
                            class="h-4 w-4 ml-2"
                            fill="none"
                            viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round"
                                stroke-linejoin="round"
                                stroke-width="2"
                                d="M19 9l-7 7-7-7" />
                        </svg>
                    </a>

                    <!-- Dropdown Menu -->
                    <div id="messagesDropdownMenu"
                        class="absolute right-0 mt-2 w-80 bg-white shadow-lg rounded-md hidden">
                        <div class="p-4">

                            <p class="text-sm text-gray-500">
                                <?php echo htmlspecialchars($roll_name); ?> sent you a message
                            </p>
                            <p class="text-xs text-gray-400">15 minutes ago</p>
                        </div>
                        <hr class="border-gray-200">
                        <a href="#"
                            class="block text-center text-blue-500 py-2 hover:bg-gray-100">
                            See all messages
                        </a>
                    </div>
                </div>

                <!-- Profile Dropdown -->
                <div class="relative">
                    <a href="#"
                        class="flex items-center text-gray-700 hover:text-blue-500"
                        id="profileDropdown"
                        onclick="toggleDropdown(event)">
                        <span><?php echo htmlspecialchars($sign_up_name); ?></span>
                        <!-- Dropdown Icon -->
                        <svg xmlns="http://www.w3.org/2000/svg"
                            class="h-4 w-4 ml-2"
                            fill="none"
                            viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round"
                                stroke-linejoin="round"
                                stroke-width="2"
                                d="M19 9l-7 7-7-7" />
                        </svg>
                    </a>
                    <!-- Dropdown Menu -->
                    <ul class="absolute right-0 mt-2 w-48 bg-white shadow-lg rounded-md hidden" id="dropdownMenu">
                        <li><a href="#" class="block px-4 py-2 hover:bg-gray-100">My Profile</a></li>
                        <li><a href="#" class="block px-4 py-2 hover:bg-gray-100">Settings</a></li>
                        <li><a href="#" class="block px-4 py-2 text-red-500 hover:bg-gray-100" onclick="logout()">Log Out</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    <!-- Navbar End -->

    <!-- JavaScript for Dropdown Toggle -->
    <script>
        function toggleDropdown(event) {
            event.preventDefault(); // Prevents default link behavior
            const dropdown = document.getElementById('dropdownMenu');
            dropdown.classList.toggle('hidden'); // Toggle visibility
        }

        // Close dropdown when clicking outside
        document.addEventListener('click', (event) => {
            const dropdown = document.getElementById('dropdownMenu');
            const button = document.getElementById('profileDropdown');
            if (!button.contains(event.target) && !dropdown.contains(event.target)) {
                dropdown.classList.add('hidden');
            }
        });

        function toggleMessagesDropdown(event) {
            event.preventDefault(); // Prevent the default action
            const dropdownMenu = document.getElementById('messagesDropdownMenu');
            dropdownMenu.classList.toggle('hidden'); // Toggle visibility
        }

        // Close dropdown when clicking outside
        document.addEventListener('click', (event) => {
            const dropdownMenu = document.getElementById('messagesDropdownMenu');
            const dropdownToggle = document.getElementById('messagesDropdownToggle');
            if (!dropdownToggle.contains(event.target) && !dropdownMenu.contains(event.target)) {
                dropdownMenu.classList.add('hidden');
            }
        });

        // Example logout function
        function logout() {
            alert('Logging out...');
            // Perform logout actions, e.g., redirect to a logout page
            window.location.href = 'logout.php'; // Update with your logout page
        }
    </script>

</body>

</html>