<?php
// Include database connection
include('header.php');
include('sidebar.php');
include('db_connection.php');


// Handle form submissions (Add, Update, Delete)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_faq'])) {
        // Add a new FAQ
        $question = $_POST['question'];
        $answer = $_POST['answer'];
        $stmt = $conn->prepare("INSERT INTO faq (question, answer) VALUES (?, ?)");
        $stmt->execute([$question, $answer]);
    } elseif (isset($_POST['update_faq'])) {
        // Update an existing FAQ
        $id = $_POST['id'];
        $question = $_POST['question'];
        $answer = $_POST['answer'];
        $stmt = $conn->prepare("UPDATE faq SET question = ?, answer = ? WHERE id = ?");
        $stmt->execute([$question, $answer, $id]);
    } elseif (isset($_POST['delete_faq'])) {
        // Delete an FAQ
        $id = $_POST['id'];
        $stmt = $conn->prepare("DELETE FROM faq WHERE id = ?");
        $stmt->execute([$id]);
    }
}

// Fetch all FAQs
$stmt = $conn->query("SELECT * FROM faq ORDER BY id DESC");
$faqs = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - FAQ Management</title>
    <!-- Bootstrap CSS for styling -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>

<body>

    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4">
                    <h6 class="mb-4">Manage FAQs</h6>

                    <!-- Form for adding a new FAQ -->
                    <form action="faq.php" method="POST">
                        <div class="mb-3">
                            <label for="question" class="form-label">Question</label>
                            <input type="text" class="form-control" id="question" name="question" placeholder="Enter question" required>
                        </div>

                        <div class="mb-3">
                            <label for="answer" class="form-label">Answer</label>
                            <textarea class="form-control" id="answer" name="answer" placeholder="Enter answer" rows="3" required></textarea>
                        </div>

                        <button type="submit" class="btn btn-primary" name="add_faq">Add FAQ</button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Display existing FAQs -->
        <div class="row g-4 mt-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4">
                    <h6 class="mb-4">Existing FAQs</h6>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Question</th>
                                    <th>Answer</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($faqs as $faq) : ?>
                                    <tr>
                                        <td><?= htmlspecialchars($faq['question']) ?></td>
                                        <td><?= htmlspecialchars($faq['answer']) ?></td>
                                        <td>
                                            <!-- Inline Form for Editing FAQ -->
                                            <form method="post" class="d-inline-block">
                                                <input type="hidden" name="id" value="<?= $faq['id'] ?>">
                                                <input type="text" name="question" class="form-control mb-2" value="<?= htmlspecialchars($faq['question']) ?>" required>
                                                <textarea name="answer" class="form-control mb-2" required><?= htmlspecialchars($faq['answer']) ?></textarea>
                                                <button type="submit" class="btn btn-warning" name="update_faq">Update</button>
                                            </form>
                                            <!-- Inline Form for Deleting FAQ -->
                                            <form method="post" class="d-inline-block">
                                                <input type="hidden" name="id" value="<?= $faq['id'] ?>">
                                                <button type="submit" class="btn btn-danger" name="delete_faq" onclick="return confirm('Are you sure?')">Delete</button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS and dependencies -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</body>

</html>