<?php
include('header.php');
include('sidebar.php');
include('db_connection.php');

// Directory for uploads
$target_dir = "uploads/";

// Check if the directory exists, if not, create it
if (!is_dir($target_dir)) {
    mkdir($target_dir, 0777, true); // Creates directory with full permissions
}

// Handle form submissions for adding, editing, and deleting design steps
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Add or Edit design step
    if (isset($_POST['submit'])) {
        $step_title = $_POST['step_title'];
        $step_description = $_POST['step_description'];
        $image_path = null;

        // Handle file upload
        if (!empty($_FILES['image']['name'])) {
            $image_path = $target_dir . basename($_FILES['image']['name']);
            if (move_uploaded_file($_FILES['image']['tmp_name'], $image_path)) {
                // Check if it's an update or a new entry
                if (isset($_POST['edit_id']) && $_POST['edit_id'] != "") {
                    // Update existing design step
                    $query = "UPDATE design SET step_title = :step_title, step_description = :step_description, image_path = :image_path WHERE id = :id";
                    $stmt = $conn->prepare($query);
                    $stmt->bindParam(':id', $_POST['edit_id']);
                } else {
                    // Insert new design step
                    $query = "INSERT INTO design (step_title, step_description, image_path) VALUES (:step_title, :step_description, :image_path)";
                    $stmt = $conn->prepare($query);
                }

                $stmt->bindParam(':step_title', $step_title);
                $stmt->bindParam(':step_description', $step_description);
                $stmt->bindParam(':image_path', $image_path);
                $stmt->execute();
            } else {
                echo "Failed to upload file.";
            }
        }
    }

    // Delete design step
    if (isset($_POST['delete'])) {
        $id = $_POST['delete'];
        $stmt = $conn->prepare("DELETE FROM design WHERE id = :id");
        $stmt->bindParam(':id', $id);
        $stmt->execute();
    }
}

// Fetch existing design steps
$stmt = $conn->query("SELECT * FROM design");
$design_steps = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
</head>

<body>
    <!-- Form Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4">
                    <h6 class="mb-4">Manage Design Steps</h6>

                    <!-- Form for adding/editing design steps -->
                    <form action="design.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="edit_id" id="edit_id">

                        <!-- Step Title -->
                        <div class="mb-3">
                            <label for="step_title" class="form-label">Step Title</label>
                            <input type="text" class="form-control" id="step_title" name="step_title" placeholder="Enter step title" required>
                        </div>

                        <!-- Step Description -->
                        <div class="mb-3">
                            <label for="step_description" class="form-label">Step Description</label>
                            <textarea class="form-control" id="step_description" name="step_description" placeholder="Enter step description" rows="3" required></textarea>
                        </div>

                        <!-- Image -->
                        <div class="mb-3">
                            <label for="image" class="form-label">Step Image</label>
                            <input type="file" class="form-control" id="image" name="image">
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-primary" name="submit">Save</button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Display existing design steps -->
        <div class="row g-4 mt-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4">
                    <h6 class="mb-4">Existing Design Steps</h6>
                    <div class="row">
                        <?php foreach ($design_steps as $row): ?>
                            <div class="col-md-4 mb-3">
                                <div class="card h-100">
                                    <?php if ($row['image_path']): ?>
                                        <img src="<?= $row['image_path'] ?>" class="card-img-top" alt="<?= $row['step_title'] ?>">
                                    <?php endif; ?>
                                    <div class="card-body">
                                        <h5 class="card-title"><?= $row['step_title'] ?></h5>
                                        <p class="card-text"><?= $row['step_description'] ?></p>
                                        <form method="POST" style="display:inline;">
                                            <button type="submit" class="btn btn-warning" name="edit" value="<?= $row['id'] ?>" onclick="editStep(<?= $row['id'] ?>, '<?= $row['step_title'] ?>', '<?= $row['step_description'] ?>')">Edit</button>
                                            <button type="submit" class="btn btn-danger" name="delete" value="<?= $row['id'] ?>">Delete</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript to populate the form when editing -->
    <script>
        function editStep(id, title, description) {
            document.getElementById('edit_id').value = id;
            document.getElementById('step_title').value = title;
            document.getElementById('step_description').value = description;
        }
    </script>
</body>

</html>