<?php

include 'header.php';
include 'sidebar.php';
include 'db_connection.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $headline = $_POST['headline'];
    $description = $_POST['description'];
    $access_text = $_POST['access_text'];
    $images = json_encode($_POST['images']); // Assumes images are URLs
    $main_image = $_POST['main_image'];

    // Prepare and execute the SQL statement
    $query = "INSERT INTO banner_content (headline, description, images, main_image, access_text)
              VALUES (:headline, :description, :images, :main_image, :access_text)";
    $stmt = $conn->prepare($query);

    // Bind parameters
    $stmt->bindParam(':headline', $headline);
    $stmt->bindParam(':description', $description);
    $stmt->bindParam(':images', $images);
    $stmt->bindParam(':main_image', $main_image);
    $stmt->bindParam(':access_text', $access_text);

    // Execute the statement
    if ($stmt->execute()) {
        echo "Banner content updated successfully.";
    } else {
        echo "Error updating banner content.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
</head>

<body>

    <!-- Form Start -->
    <div class="container-fluid pt-4 px-4">
        <div class="row g-4">
            <div class="col-12">
                <div class="bg-light rounded h-100 p-4 pr-5" style="padding-right: 2rem;">
                    <h6 class="mb-4">Update Banner Content</h6>
                    <form action="banner.php" method="POST">

                        <!-- Headline -->
                        <div class="mb-3">
                            <label for="headline" class="form-label">Headline</label>
                            <input type="text" class="form-control" id="headline" name="headline" placeholder="Enter headline text" required>
                        </div>

                        <!-- Description -->
                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" id="description" name="description" placeholder="Enter a brief description" rows="3" required></textarea>
                        </div>

                        <!-- Main Image URL -->
                        <div class="mb-3">
                            <label for="main_image" class="form-label">Main Image URL</label>
                            <input type="text" class="form-control" id="main_image" name="main_image" placeholder="e.g., images/house.jpg" required>
                        </div>

                        <!-- Access Text -->
                        <div class="mb-3">
                            <label for="access_text" class="form-label">Access Text</label>
                            <input type="text" class="form-control" id="access_text" name="access_text" placeholder="e.g., '1,600 people requested access'" required>
                        </div>

                        <!-- Image URLs -->
                        <div class="mb-3">
                            <label for="images" class="form-label">Image URLs (comma-separated)</label>
                            <input type="text" class="form-control" id="images" name="images[]" placeholder="e.g., images/face1.jpg, images/face2.jpg" required>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" class="btn btn-primary">Save</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

</body>

</html>