<?php
// Include database connection
include 'db_connection.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize and validate input data
    $first_name = filter_var($_POST['first_name'], FILTER_SANITIZE_STRING);
    $last_name = filter_var($_POST['last_name'], FILTER_SANITIZE_STRING);
    $street_address = filter_var($_POST['street_address'], FILTER_SANITIZE_STRING);
    $apt_number = filter_var($_POST['apt_number'], FILTER_SANITIZE_STRING);
    $state = filter_var($_POST['state'], FILTER_SANITIZE_STRING);
    $zip_code = filter_var($_POST['zip_code'], FILTER_SANITIZE_STRING);

    // Validate required fields
    if (!empty($first_name) && !empty($last_name) && !empty($street_address) && !empty($state) && !empty($zip_code)) {
        try {
            // Insert data into the shipping table
            $stmt = $conn->prepare("INSERT INTO shipping (first_name, last_name, street_address, apt_number, state, zip_code) 
                                    VALUES (:first_name, :last_name, :street_address, :apt_number, :state, :zip_code)");
            $stmt->bindParam(':first_name', $first_name);
            $stmt->bindParam(':last_name', $last_name);
            $stmt->bindParam(':street_address', $street_address);
            $stmt->bindParam(':apt_number', $apt_number);
            $stmt->bindParam(':state', $state);
            $stmt->bindParam(':zip_code', $zip_code);

            $stmt->execute();
            echo "Shipping address saved successfully!";
        } catch (PDOException $e) {
            echo "Error: " . $e->getMessage();
        }
    } else {
        echo "Please fill in all required fields.";
    }
}
?>
